/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.commands;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.sponge.contexts.OnlinePlayer;
import net.skinsrestorer.shared.commands.ISRCommand;
import net.skinsrestorer.sponge.SkinsRestorer;
import net.skinsrestorer.sponge.utils.WrapperSponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand
implements ISRCommand {
    private final SkinsRestorer plugin;

    @HelpCommand
    @Syntax(value="%helpHelpCommand")
    public void onHelp(CommandSource source, CommandHelp help) {
        this.onHelp(WrapperSponge.wrapCommandSender(source), help);
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSource source) {
        this.onReload(WrapperSponge.wrapCommandSender(source));
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSource source) {
        this.onStatus(WrapperSponge.wrapCommandSender(source));
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSource source, ISRCommand.PlayerOrSkin playerOrSkin, String target) {
        this.onDrop(WrapperSponge.wrapCommandSender(source), playerOrSkin, target);
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSource source, @Single OnlinePlayer target) {
        this.onProps(WrapperSponge.wrapCommandSender(source), WrapperSponge.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSource source, @Single OnlinePlayer target) {
        this.onApplySkin(WrapperSponge.wrapCommandSender(source), WrapperSponge.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [classic/slim]")
    public void onCreateCustom(CommandSource source, String name, String skinUrl, @Optional SkinVariant skinVariant) {
        this.onCreateCustom(WrapperSponge.wrapCommandSender(source), name, skinUrl, skinVariant);
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [classic/slim]")
    public void onSetSkinAll(CommandSource source, String skin, @Optional SkinVariant skinVariant) {
        this.onSetSkinAll(WrapperSponge.wrapCommandSender(source), skin, skinVariant);
    }

    @Subcommand(value="purgeolddata")
    @Description(value="Purge old skin data from over x days ago")
    @Syntax(value=" <targetdaysold>")
    public void onPurgeOldData(CommandSource source, int days) {
        this.onPurgeOldData(WrapperSponge.wrapCommandSender(source), days);
    }

    @Override
    public String getPlatformVersion() {
        return this.plugin.getGame().getPlatform().getMinecraftVersion().getName();
    }

    @Override
    public String getProxyMode() {
        return "Sponge-Plugin";
    }

    @Override
    public List<IProperty> getPropertiesOfPlayer(ISRPlayer player) {
        Collection properties = player.getWrapper().get(Player.class).getProfile().getPropertyMap().get((Object)"textures");
        return properties.stream().map(property -> new GenericProperty(property.getName(), property.getValue(), property.getSignature().orElse(""))).collect(Collectors.toList());
    }

    public SrCommand(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

